Imports System.Runtime.InteropServices

Public Class BLUEBOXLibClass_x64
    Implements BLUEBOXLibInterface

    <DllImport("/x64/BLUEBOXLib.dll")> _
    Public Shared Function BLUEBOX_GetSwRelease(ByVal SwRel As System.Text.StringBuilder) As Integer

    End Function

    <DllImport("/x64/BLUEBOXLib.dll")> _
    Public Shared Function BLUEBOX_Init(ByRef Handle As Integer) As Integer

    End Function

    <DllImport("/x64/BLUEBOXLib.dll")> _
    Public Shared Function BLUEBOX_End(ByRef Handle As Integer) As Integer

    End Function

    <DllImport("/x64/BLUEBOXLib.dll")> _
    Public Shared Function BLUEBOX_SetAddress(ByRef Handle As Integer, ByVal Address As Byte) As Integer

    End Function

    <DllImport("/x64/BLUEBOXLib.dll")> _
    Public Shared Function BLUEBOX_SetChannel(ByRef Handle As Integer, ByVal Channel As String, ByVal Settings As String) As Integer

    End Function

    <DllImport("/x64/BLUEBOXLib.dll")> _
    Public Shared Function BLUEBOX_Open(ByRef Handle As Integer) As Integer

    End Function

    <DllImport("/x64/BLUEBOXLib.dll")> _
    Public Shared Function BLUEBOX_Close(ByRef Handle As Integer) As Integer

    End Function

    <DllImport("/x64/BLUEBOXLib.dll")> _
    Public Shared Function BLUEBOX_GetFwRelease(ByRef Handle As Integer, ByVal Reader As Integer, ByVal FwRel As System.Text.StringBuilder) As Integer

    End Function

    <DllImport("/x64/BLUEBOXLib.dll")> _
    Public Shared Function BLUEBOX_ReadParameters(ByRef Handle As Integer, ByVal Reader As Byte()) As Integer

    End Function

    <StructLayout(LayoutKind.Sequential)> _
    Public Structure BLUEBOX_Tag
        Public TagType As Integer
        Public Id As IntPtr
        Public Length As Integer
        Public Antenna As Integer
        Public Input As Integer
    End Structure

    <DllImport("/x64/BLUEBOXLib.dll")> _
    Public Shared Function BLUEBOX_DataRequest(ByRef Handle As Integer, ByRef Tags As IntPtr, ByRef TagsNo As Integer) As Integer

    End Function

    <DllImport("/x64/BLUEBOXLib.dll")> _
    Public Shared Function BLUEBOX_FreeTagsMemory(ByRef Handle As Integer, ByRef Tags As IntPtr, ByVal TagsNo As Integer) As Integer

    End Function

    Public Function _GetSwRelease(ByVal SwRel As System.Text.StringBuilder) As Integer Implements BLUEBOXLibInterface._GetSwRelease
        Return BLUEBOX_GetSwRelease(SwRel)
    End Function

    Public Function _Init(ByRef Handle As Integer) As Integer Implements BLUEBOXLibInterface._Init
        Return BLUEBOX_Init(Handle)
    End Function

    Public Function _End(ByRef Handle As Integer) As Integer Implements BLUEBOXLibInterface._End
        Return BLUEBOX_End(Handle)
    End Function

    Public Function _SetAddress(ByRef Handle As Integer, ByVal Address As Byte) As Integer Implements BLUEBOXLibInterface._SetAddress
        Return BLUEBOX_SetAddress(Handle, Address)
    End Function

    Public Function _SetChannel(ByRef Handle As Integer, ByVal Channel As String, ByVal Settings As String) As Integer Implements BLUEBOXLibInterface._SetChannel
        Return BLUEBOX_SetChannel(Handle, Channel, Settings)
    End Function

    Public Function _Open(ByRef Handle As Integer) As Integer Implements BLUEBOXLibInterface._Open
        Return BLUEBOX_Open(Handle)
    End Function

    Public Function _Close(ByRef Handle As Integer) As Integer Implements BLUEBOXLibInterface._Close
        Return BLUEBOX_Close(Handle)
    End Function

    Public Function _GetFwRelease(ByRef Handle As Integer, ByVal Reader As Integer, ByVal FwRel As System.Text.StringBuilder) As Integer Implements BLUEBOXLibInterface._GetFwRelease
        Return BLUEBOX_GetFwRelease(Handle, Reader, FwRel)
    End Function

    Public Function _ReadParameters(ByRef Handle As Integer, ByVal Reader() As Byte) As Integer Implements BLUEBOXLibInterface._ReadParameters
        Return BLUEBOX_ReadParameters(Handle, Reader)
    End Function

    Public Function _DataRequest(ByRef Handle As Integer, ByRef Tags As System.IntPtr, ByRef TagsNo As Integer) As Integer Implements BLUEBOXLibInterface._DataRequest
        Return BLUEBOX_DataRequest(Handle, Tags, TagsNo)
    End Function

    Public Function _FreeTagsMemory(ByRef Handle As Integer, ByRef Tags As System.IntPtr, ByVal TagsNo As Integer) As Integer Implements BLUEBOXLibInterface._FreeTagsMemory
        Return BLUEBOX_FreeTagsMemory(Handle, Tags, TagsNo)
    End Function

End Class
